defmodule MissionControlEx.Web.ChannelCommand do
  use MissionControlEx.Web, :model

  schema "channel_commands" do
    belongs_to(:channel, MissionControlEx.Web.Channel, foreign_key: :channel_id)
    belongs_to(:chat_command, MissionControlEx.Web.ChatCommand, foreign_key: :chat_command_id)

    timestamps()
  end

  @doc """
  Builds a changeset based on the `struct` and `params`.
  """
  def changeset(struct, params \\ %{}) do
    struct
    |> cast(params, [:channel_id, :chat_command_id])
    |> validate_required([:channel_id, :chat_command_id])
  end
end
