defmodule MissionControlEx.Web.ChatCommand do
  use MissionControlEx.Web, :model

  schema "chat_commands" do
    field(:command, :string)
    field(:message_template, :string)
    field(:fallback_message, :string, default: nil)
    field(:auto_send, :boolean, default: false)

    has_many(
      :channel_commands,
      MissionControlEx.Web.ChannelCommand,
      foreign_key: :chat_command_id
    )

    has_many(
      :channels,
      through: [
        :channel_commands,
        :channel,
        :fallback_message,
        :use_future_event
      ]
    )

    timestamps()
  end

  @doc """
  Builds a changeset based on the `struct` and `params`.
  """
  def changeset(struct, params \\ %{}) do
    struct
    |> cast(params, [:command, :message_template, :fallback_message])
    |> validate_required([:command, :message_template])
  end

  def get_by_command(command) do
    Repo.one(from(c in __MODULE__, where: c.command == ^command))
  end
end
