defmodule EventChunkList do
  @behaviour Ecto.Type
  def type, do: :binary

  # Cast always returns term, make sure to not double-convert
  def cast(bin) when is_list(bin), do: {:ok, bin}
  def cast(bin) when is_binary(bin), do: {:ok, bin |> :erlang.binary_to_term()}

  # Load returns term, loaded from DB so always binary
  def load(bin), do: {:ok, bin |> :erlang.binary_to_term()}

  # Dump returns binary, used for insert and cast so always takes in term
  def dump(bin), do: {:ok, bin |> :erlang.term_to_binary()}
end
