defmodule TranscodeRangers do
  require Utils
  @bucket "twitch-creative-video-repository"
  def transcode do
    objects =
      ExAws.S3.list_objects(@bucket, prefix: "raw/power_rangers")
      |> ExAws.stream!()
      |> Enum.to_list()

    %{video: videos, subtitles: subtitles} = group_s3_by_file_types(objects)
    videos_by_file_number = files_by_file_number(videos)
    subtitles_by_file_number = files_by_file_number(subtitles)

    File.read!("power_rangers_manifest.txt")
    |> String.split("\n")
    |> Enum.reject(&(String.length(&1) == 0))
    |> Enum.map(fn line ->
         [season, position, episode | title] = String.split(line, ~r/ |\t/)
         title = Enum.join(title, " ")
         {position, _} = Integer.parse(position)
         video = Map.get(videos_by_file_number, position) |> List.first()
         subtitle = Map.get(subtitles_by_file_number, position) |> List.first()

         %{
           season: season,
           position: position,
           episode: episode,
           title: String.replace(title, "\"", ""),
           video: video,
           subtitle: subtitle
         }
       end)
  end

  def group_s3_by_file_types(files) do
    Enum.group_by(files, &Utils.get_type(&1.key))
  end

  def files_by_file_number(files) do
    Enum.group_by(files, fn file ->
      case Regex.run(~r/((?:NM)|(?:HDM))([0-9]{3})/, file.key) do
        nil ->
          nil

        name ->
          {int, _} =
            name
            |> List.last()
            |> Integer.parse()

          int
      end
    end)
  end
end
