defmodule MissionControlEx.Web.ErrorView do
  use MissionControlEx.Web, :view

  def render("404.html", _assigns) do
    "Page not found"
  end

  def render("500.html", _assigns) do
    "Internal server error"
  end

  def render("event_persist_error.json", %{event: event}) do
    %{error: "Event Persist Error", event: event}
  end

  def render("changeset_error.json", %{changeset_errors: changeset_errors}) do
    %{changeset_errors: changeset_errors}
  end

  def render("preview_error.json", %{error: error}) do
    error
  end

  def render("404.json", _assigns) do
    "Not Found"
  end

  # In case no render clause matches or no
  # template is found, let's render it as 500
  def template_not_found(_template, assigns) do
    render("500.html", assigns)
  end
end
