defmodule MissionControlEx.Web.StreamScheduleView do
  use MissionControlEx.Web, :view
  alias MissionControlEx.Web.StreamSchedule

  def render("index.json", %{stream_schedules: stream_schedules}),
    do: %{schedules: render_many(stream_schedules, __MODULE__, "show.json")}

  def render("edit.json", %{stream_schedule: stream_schedule}), do: stream_schedule

  def render("show.json", %{stream_schedule: stream_schedule} = assigns),
    do: Map.merge(stream_schedule, Map.delete(assigns, :stream_schedule))

  def render("ts_assets.json", %{stream_schedule: stream_schedule, assets: assets, feeds: feeds}) do
    %{
      id: stream_schedule.id,
      name: stream_schedule.name,
      assets: render_many(assets, MissionControlEx.Web.AssetView, "asset.json"),
      feeds: render_many(feeds, MissionControlEx.Web.FeedView, "feed.json")
    }
  end
end
