defmodule MissionControlEx.Web.ClipFetcher do
  use HTTPoison.Base
  alias ExAws.S3
  require Utils

  def get_clip(url) do
    slug =
      String.split(url, "\/")
      |> Enum.at(-1)
      |> get_clip_url
      |> HTTPoison.get!(RequestUtils.headers_v5())
      |> RequestUtils.unpack_body_from_response()
  end

  def get_clip_url(slug), do: "https://api.twitch.tv/kraken/clips/#{slug}"

  def download_clip(url, path) do
    clip_data = get_clip(url)

    overlay_path =
      MissionControlEx.Web.Event.generate_curator_overlay(clip_data, path <> "_overlay.tmp.ts")

    render_clip(url, path, overlay_path)
  end

  def render_clip(url, path, overlay_path) do
    opts = [out: :stream, err: nil]
    # opts = opts ++ [env: %{"FFREPORT" => "file=/Users/$USER/logs/buffer-\%p-\%t.log"}]
    %{out: stream} =
      Porcelain.spawn_shell(
        """
        youtube-dl --no-continue -f \"mp4\" -o - \"#{url}\" | \
        ffmpeg -y -i - -itsoffset 1.25 -i \"#{overlay_path}\" \
        -filter_complex \"[1:v]colorkey=black[t];[0:v]scale=1920:1080[s];[s][t]overlay=15:15:eof_action=pass[out]\" \
        -map \'[out]\' -map 0:a:0 \
        -c:v libx264 -preset:v veryfast -crf 13 -pix_fmt yuv420p -threads 0 -r 30 -fflags +genpts \
        -c:a aac -b:a 48k -ar 48000 -ac 2 \
        -f mpegts #{path}
        """,
        opts
      )

    stream
  end
end
