defmodule RequestUtils do
  require Utils

  def headers(),
    do: [
      "Accept-Encoding": "gzip, deflate, sdch, br",
      Accept: "application/vnd.twitchtv.v4+json",
      "Client-Id": "jzkbprff40iqj646a697cyrvl0zt2m6"
    ]

  def headers_v5(),
    do: [
      "Accept-Encoding": "gzip, deflate, sdch, br",
      Accept: "application/vnd.twitchtv.v5+json",
      "Client-Id": "jzkbprff40iqj646a697cyrvl0zt2m6"
    ]

  def unpack_body_from_response(res) do
    gzipped =
      Enum.any?(res.headers, fn kv ->
        case kv do
          {"Content-Encoding", "gzip"} -> true
          _ -> false
        end
      end)

    body =
      case gzipped do
        true -> :zlib.gunzip(res.body)
        _ -> res.body
      end

    Poison.decode!(body)
  end
end
