defmodule TwitchApiUtils do
  use HTTPoison.Base
  require Logger

  def get_json(url) do
    %{out: output} = Porcelain.shell("youtube-dl --dump-json \"#{url}\"")

    case output do
      "" ->
        {:error, :not_video_url}

      output ->
        output
        |> Poison.decode!()
        |> get_duration
        |> assure_correct_url
        |> Map.take(["url", "duration", "title", "thumbnail"])
    end
  end

  defp get_duration(%{"duration" => duration} = json), do: %{json | "duration" => duration * 1000}

  defp get_duration(%{"url" => url} = json),
    do: Map.put(json, "duration", FFprobe.get_duration(url))

  defp assure_correct_url(%{"webpage_url" => url} = json), do: Map.put(json, "url", url)
  defp assure_correct_url(json), do: json
end
