defmodule MissionControlEx.Web.TranscoderJobConsumer do
  use ConsumerSupervisor
  @media_path Application.get_env(:mission_control_ex, :media_path)

  def start_link() do
    ConsumerSupervisor.start_link(__MODULE__, :ok)
  end

  def init(:ok) do
    children = [
      worker(Transcode, [], restart: :temporary)
    ]

    opts = [
      strategy: :one_for_one,
      subscribe_to: [{MissionControlEx.Web.TranscoderJobProducer, max_demand: 2}]
    ]

    {:ok, _files} = File.rm_rf("#{@media_path}")

    {:ok, children, opts}
  end
end
