defmodule FFprobe do
  def get_duration(file_path) do
    proc = Porcelain.shell("ffprobe -i \"#{file_path}\" -show_format -of json", [])
    {:ok, resp} = Poison.decode(proc.out)

    case get_in(resp, ["format", "duration"]) do
      nil ->
        nil

      duration_string ->
        {duration, _} = duration_string |> Float.parse()
        round(duration * 1000)
    end
  end
end
