defmodule StreamSetup do
  @doc """
  Takes in an array of s3_path strings and a twitch stream, creates assets and stream_assets
  ready to run as a test stream
  """
  def add_assets_to_db(list, twitch_stream), do: add_assets_to_db(list, twitch_stream, 0)

  def add_assets_to_db([h | t], twitch_stream, index) do
    IO.inspect("inserting #{h} into db")

    {:ok, asset} =
      MissionControlEx.Web.Asset.new_asset_from_s3_path(h, %{metadata: %{"episode" => 1}})

    IO.inspect(asset)
    add_assets_to_db(t, twitch_stream, index + 1)
  end

  def add_assets_to_db([], twitch_stream, index), do: "done"
end
