defmodule MissionControlEx.Web.Mixfile do
  use Mix.Project

  def project do
    [
      app: :mission_control_ex,
      version: "0.0.1",
      elixir: ">= 1.5.0",
      elixirc_paths: elixirc_paths(Mix.env()),
      compilers: [:phoenix, :gettext] ++ Mix.compilers(),
      build_embedded: false,
      start_permanent: false,
      aliases: aliases(),
      deps: deps()
    ]
  end

  # Configuration for the OTP application.
  #
  # Type `mix help compile.app` for more information.
  def application do
    [
      mod: {MissionControlEx, []},
      applications: [
        :phoenix,
        :phoenix_pubsub,
        :phoenix_html,
        :cowboy,
        :logger,
        :gettext,
        :ex_aws,
        :sweet_xml,
        :hackney,
        :poison,
        :porcelain,
        :libcluster,
        :httpoison,
        :phoenix_ecto,
        :postgrex,
        :delayed_otp,
        :ex_machina,
        :table_rex,
        :briefly,
        :exirc,
        :rollbax,
        :quantum,
        :gen_stage,
        :crontab,
        :timex,
        :ueberauth_twitch_tv,
        :con_cache,
        :async_with,
        :retry
      ]
    ]
  end

  # Specifies which paths to compile per environment.
  defp elixirc_paths(:test), do: ["lib", "test/support"]
  defp elixirc_paths(_), do: ["lib"]

  # Specifies your project dependencies.
  #
  # Type `mix help deps` for examples and options.
  defp deps do
    [
      {:phoenix, "~> 1.3.0-rc", override: true},
      {:phoenix_pubsub, "~> 1.0"},
      {:phoenix_html, "~> 2.6"},
      {:phoenix_live_reload, "~> 1.0", only: :dev},
      {:gettext, "~> 0.11"},
      {:briefly, "~> 0.3"},
      {:cowboy, "~> 1.0"},
      {:ex_aws, "~> 1.1.0"},
      {:configparser_ex, "~> 0.2.1"},
      {:poison, "3.0.0", override: true},
      {:sweet_xml, "~> 0.6"},
      {:hackney, "1.6.1", override: true},
      {:libcluster, "~> 2.0"},
      {:fsm, "~> 0.3.0"},
      {:porcelain, "~> 2.0"},
      # Do not upgrade without fixing clip_scraper.ex. See: https://github.com/edgurgel/httpoison/issues/81
      {:httpoison, "~> 0.11.0"},
      {:phoenix_ecto, "~> 3.0"},
      {:postgrex, ">= 0.0.0"},
      {:quantum, ">= 1.9.0"},
      {:delayed_otp, "~> 0.0.1"},
      {:ex_machina, "~> 1.0"},
      {:csv, "~> 2.0.0"},
      {:rollbax, "~> 0.6"},
      {:exirc, "~> 1.0.0"},
      {:gen_stage, "~> 0.12.2"},
      {:crontab, "~> 1.0.0"},
      {:ex_json_schema, "~> 0.5.4"},
      {:table_rex, "~> 0.10"},
      {:timex, "~> 3.0"},
      {:flow, "~> 0.11"},
      {:eqc_ex, "~> 1.4"},
      {:xml_builder, "~> 0.0.6"},
      {:ueberauth_twitch_tv, "~> 0.3.0"},
      {:react_phoenix, "~> 0.4.3", override: true},
      {:async_with, "~> 0.2"},
      {:con_cache, "~> 0.12.1"},
      {:benchwarmer, "~> 0.0.2"},
      {:retry, "~> 0.8"}
    ]
  end

  defp aliases do
    [
      "ecto.setup": ["ecto.create", "ecto.migrate", "run priv/repo/seeds/seed.exs"],
      "ecto.reset": ["ecto.drop", "ecto.setup"],
      "ecto.fresh": ["ecto.drop", "ecto.create", "ecto.migrate"],
      "ecto.empty_stream": ["ecto.create", "ecto.migrate", "run priv/repo/empty_stream_seed.exs"],
      "ecto.basic_stream": [
        "ecto.drop",
        "ecto.create",
        "ecto.migrate",
        "run priv/repo/basic_stream_seed.exs"
      ],
      dev_prod_sim: ["ecto.fresh", "ecto.load -d db.sql", "run priv/repo/dev_stream.exs"]
    ]
  end
end
