defmodule MissionControlEx.Web.Repo.Migrations.CreatePolicy do
  use Ecto.Migration

  def change do
    create table(:policies) do
      add :type, :string
      add :intermission_asset_ids, {:array, :integer}
      add :blacklist_regexes, {:array, :string}
      add :whitelist_regexes, {:array, :string}
      add :played_asset_ids, {:array, :integer}
      add :channel_id, references(:channels, on_delete: :nothing)

      timestamps()
    end
    create index(:policies, [:channel_id])

  end
end
