defmodule MissionControlEx.Web.Repo.Migrations.TwitchStreamAdded do
  use Ecto.Migration

  def change do
    drop table(:policy_assets)
    drop table(:policies)
    create table(:twitch_streams) do
      add :state, :string
      add :type, :string
      add :last_played_id, :integer

      add :requested_clip_ids, {:array, :integer}
      add :intermission_asset_ids, {:array, :integer}
      add :blacklist_regexes, {:array, :string}
      add :whitelist_regexes, {:array, :string}
      add :played_asset_ids, {:array, :integer}

      add :channel_id, references(:channels, on_delete: :nothing)

      timestamps()
    end
    create index(:twitch_streams, [:channel_id])

    create table(:stream_assets) do
      add :twitch_stream_id, references(:twitch_streams, on_delete: :nothing)
      add :asset_id, references(:assets, on_delete: :nothing)
      add :position, :integer

      timestamps()
    end
    create index(:stream_assets, [:twitch_stream_id])
    create index(:stream_assets, [:asset_id])

    alter table(:channels) do
      remove :current_policy_id
      add :current_twitch_stream_id, :integer
    end

    create table(:airings) do
      add :twitch_stream_id, :integer
      add :channel_id, :integer
      add :start_time, :utc_datetime, default: nil
      add :end_time, :utc_datetime, default: nil

      timestamps()
    end
  end
end
