defmodule MissionControlEx.Web.Repo.Migrations.CreateManifest do
  use Ecto.Migration

  def change do
    create table(:manifests) do
      add :status, :string
      add :name, :string
      add :manifest, :text

      timestamps()
    end
    create unique_index(:manifests, [:name])

    alter table(:assets) do
      modify :inserted_at, :utc_datetime, default: fragment("NOW()")
      modify :updated_at, :utc_datetime, default: fragment("NOW()")
      modify :trimmings, :text, default: ""
      remove :s3_transcode_path
    end
    create unique_index(:assets, [:source_movie, :trimmings])
    drop index(:assets, [:id, :s3_path], unique: true)

    create table(:manifests_assets, primary_key: false) do
      add :manifest_id, references(:manifests, on_delete: :delete_all)
      add :asset_id, references(:assets, on_delete: :delete_all)
      add :inserted_at, :utc_datetime, default: fragment("NOW()")
      add :updated_at, :utc_datetime, default: fragment("NOW()")
    end
    create index(:manifests_assets, [:manifest_id])
    create index(:manifests_assets, [:asset_id])
  end
end
