defmodule MissionControlEx.Web.Repo.Migrations.KillStreamAsset do
  use Ecto.Migration
  use MissionControlEx.Web, :model
  alias MissionControlEx.Web.Repo
  alias MissionControlEx.Web.Asset

  schema "stream_assets" do
    belongs_to :twitch_stream, MissionControlEx.Web.TwitchStream
    belongs_to :asset, MissionControlEx.Web.Asset
    field :position, :integer
  end

  def change do
    {:ok, result} = Repo.transaction fn()->
      from(
        s in "stream_assets",
        join: a in "assets",
        where: s.asset_id == a.id,
        where: not is_nil(a.type),
        select: %{asset_id: s.asset_id, twitch_stream_id: s.twitch_stream_id, position: s.position},
      )
      |> Repo.all
      |> Enum.map(fn(stream_asset) -> create_asset_update(stream_asset) end)
      |> Asset.update_metafields
    end
    flush()
    drop table(:stream_assets)
    alter table(:assets) do
      remove :type
    end
  end

  def create_asset_update(%{asset_id: asset_id, twitch_stream_id: twitch_stream_id, position: position}) do
    twitch_stream = MissionControlEx.Web.TwitchStream.load(twitch_stream_id)
    asset = Repo.one!(from(a in Asset, select: a, where: a.id == ^asset_id))
    type = Repo.one!(from(a in "assets", select: a.type, where: a.id == ^asset_id))
    {asset, %{
      "legacy\_#{twitch_stream.name}\_#{type}\_seq" => position || 0,
      "legacy\_show\_name" => twitch_stream.name
    }}
  end
end
