defmodule MissionControlEx.Web.Repo.Migrations.RemoveScheduleManagerAssocOnDeletions do
  use Ecto.Migration

  def up do
    execute "ALTER TABLE twitch_streams DROP CONSTRAINT twitch_streams_schedule_manager_id_fkey"
    alter table(:twitch_streams) do
      modify :schedule_manager_id, references(:airings, on_delete: :nilify_all)
    end
  end

  def down do
    execute "ALTER TABLE twitch_streams DROP CONSTRAINT twitch_streams_schedule_manager_id_fkey"
    alter table(:twitch_streams) do
      modify :schedule_manager_id, references(:airings, on_delete: :nothing)
    end
  end
end
