defmodule MissionControlEx.Repo.Migrations.CreateChatCommand do
  use Ecto.Migration

  def change do
    alter table(:channels) do
      add :chat_bot_enabled, :boolean, default: false
    end

    create table(:chat_commands) do
      add :command, :string
      add :message_template, :string
      add :fallback_message, :string

      timestamps()
    end

    create table(:channel_commands) do
      add :channel_id, references(:channels, on_delete: :nothing)
      add :chat_command_id, references(:chat_commands, on_delete: :nothing)

      timestamps()
    end
    create index(:channel_commands, [:channel_id])
    create index(:channel_commands, [:chat_command_id])
  end
end

