defmodule MissionControlEx.Web.Repo.Migrations.QueuedEventChunks do
  use Ecto.Migration
  alias MissionControlEx.Web.StreamSchedule

  def up do
    alter table(:twitch_streams) do
      add :queued_event_chunks, :binary
    end
    flush()

    MissionControlEx.Web.Repo.all(StreamSchedule)
    |> Enum.each(fn schedule -> StreamSchedule.update(schedule, %{queued_event_chunks: []}) end)
  end

  def down do
    alter table(:twitch_streams) do
      remove :queued_event_chunks
    end
  end
end
