alias MissionControlEx.Web.Repo
alias MissionControlEx.Web.StreamSchedule

channel = Repo.insert! %MissionControlEx.Web.Channel{
  login: "tpdevtest",
  stream_key: "live_156666452_nWHKbMW7nglxlxaSfcyNtnQR02B2o4",
  oauth_token: "rqgyml1g3hgxq4ayfm56a9ghhgowla",
  chat_bot_enabled: true
}

{:ok, cron} = Crontab.CronExpression.Parser.parse("* * * * * * *", true)
manager = Repo.insert! %MissionControlEx.Web.ScheduleManager{
  channel: channel,
  cron: cron,
  status: "waiting"
}

asset1 = Repo.insert! %MissionControlEx.Web.Asset{
  s3_path: "test/colorful_timer_5min.ts",
  duration: 300_000,
  type: "episode",
  commercial_breaks_ms: [30_000],
  metadata: %{episode: "1", season: "1", title: "This is a title"},
  status: "complete"
}

asset2 = Repo.insert! %MissionControlEx.Web.Asset{
  s3_path: "test/2min.ts",
  duration: 60_000,
  metadata: %{episode: "2", season: "1"},
  commercial_breaks_ms: [],
  status: "complete"
}

twitch_stream = Repo.insert! %StreamSchedule{
  state: "waiting",
  name: "first_stream",
  default_schedule: true,
  schedule_manager_id: manager.id,
  stack_trace: ["episode1", "main_loop"],
  stream_schema: Poison.decode!("""
    {
    "events": [
      {
        "type": "loop",
        "ref": "main_loop",
        "events": [
          {
            "type": "asset",
            "id": 1,
            "ref": "episode1"
          },
          {
            "type": "asset",
            "id": 2,
            "ref": "episode2"
          }
        ]
      }
    ]}
    """)
}

chat_command = Repo.insert! %MissionControlEx.Web.ChatCommand{
  command: "!next_episode",
  message_template: "Next episode <%= data[\"next\"][\"episode\"] %> of season <%= data[\"next\"][\"season\"] %>",
  fallback_message: "Next broke"
}

chat_command2 = Repo.insert! %MissionControlEx.Web.ChatCommand{
  command: "!current_episode",
  message_template: "Current episode <%= data[\"current\"][\"episode\"] %> of season <%= data[\"current\"][\"season\"] %>",
  fallback_message: "Can't tell you what's playing, not sure why"
}

chat_command3 = Repo.insert! %MissionControlEx.Web.ChatCommand{
  command: "!currentlybroke",
  message_template: "Broken <%= data[\"nope\"][\"episode\"] %> of season <%= data[\"nope\"][\"season\"] %>"
}

_chat_command4 = Repo.insert! %MissionControlEx.Web.ChatCommand{
  command: "!nottesting",
  message_template: "Not testing command"
}

Repo.insert! %MissionControlEx.Web.ChannelCommand{
  channel: channel,
  chat_command: chat_command
}

Repo.insert! %MissionControlEx.Web.ChannelCommand{
  channel: channel,
  chat_command: chat_command2
}

Repo.insert! %MissionControlEx.Web.ChannelCommand{
  channel: channel,
  chat_command: chat_command3
}

Repo.insert! MissionControlEx.Web.Event.do_loop(twitch_stream.id, "main_loop")
Repo.insert! MissionControlEx.Web.Event.play_asset(twitch_stream.id, "episode1", asset1, 0, "")
