alias MissionControlEx.Web.{Repo, StreamSchedule, Event, EventChunk, ScheduleManager}

channel = Repo.insert! %MissionControlEx.Web.Channel{
  login: "tpdevtest",
  oauth_token: "rqgyml1g3hgxq4ayfm56a9ghhgowla",
  chat_bot_enabled: false
}

{:ok, cron} = Crontab.CronExpression.Parser.parse("* * * * * * *", true)
manager = Repo.insert! %ScheduleManager{
  channel: channel,
  cron: cron,
  status: "notready"
}

curated_vod_urls = [
  "https://clips.twitch.tv/RoundGiftedReubenLitty",
  "https://twitch.tv/videos/171462220",
  "https://www.twitch.tv/videos/4485160",
  "https://twitch.tv/videos/182057013",
  "https://clips.twitch.tv/ObliviousBrainyHornetStoneLightning",
  "https://www.twitch.tv/videos/159249172"
]

schedule = Repo.insert! %StreamSchedule{
  state: "waiting",
  name: "curated_test_stream_seed",
  default_schedule: true,
  schedule_manager_id: manager.id,
  repeat: true,
  stop_on_empty: false
}
|> StreamSchedule.update_curated_schedule(curated_vod_urls)

StreamSchedule.persist_changes(schedule)
ScheduleManager.update(manager, %{status: "waiting"})

# chat_command = Repo.insert! %MissionControlEx.Web.ChatCommand{
#   command: "!current",
#   message_template: "<%= data[\"current\"][\"url\"] %>",
#   fallback_message: "Can't tell you what's playing, not sure why",
#   auto_send: true
# }
# chat_command2 = Repo.insert! %MissionControlEx.Web.ChatCommand{
#   command: "!vod",
#   message_template: "Check out more by this broadcaster at twitch.tv\/<%= data[\"current\"][\"broadcaster\"][\"display_name\"] %>",
#   fallback_message: "Can't tell you what's playing, not sure why",
#   auto_send: true
# }
# chat_command3 = Repo.insert! %MissionControlEx.Web.ChatCommand{
#   command: "!next",
#   message_template: "<%= data[\"next\"][\"url\"] %>",
#   fallback_message: "Can't tell you what's next, not sure why",
#   auto_send: false
# }

# Repo.insert! %MissionControlEx.Web.ChannelCommand{
#   channel: channel,
#   chat_command: chat_command
# }
# Repo.insert! %MissionControlEx.Web.ChannelCommand{
#   channel: channel,
#   chat_command: chat_command2
# }
# Repo.insert! %MissionControlEx.Web.ChannelCommand{
#   channel: channel,
#   chat_command: chat_command3
# }
