alias MissionControlEx.Web.{Repo, StreamSchedule, Channel, ScheduleManager}
#######################################################
  # NOTE you will have to change Streamer children to 3
#######################################################
{:ok, cron} = Crontab.CronExpression.Parser.parse("*/2 * * * * *")

# Channel Setup
n1devtest_channel = Repo.insert! %MissionControlEx.Web.Channel{
  login: "n1devtest",
  oauth_token: "d17i9ifomh5jv7cn6d266te5xjyhrx"
}

n2devtest_channel = Repo.insert! %MissionControlEx.Web.Channel{
  login: "n2devtest",
  oauth_token: "qi8oyivzzbpkg7bz2k7r3f0k2jpzev"
}

n3devtest_channel = Repo.insert! %MissionControlEx.Web.Channel{
  login: "n3devtest",
  oauth_token: "p0jb1fger9rd1ce3vsmtt01np6dx4w"
}

# Manager Setup
n1_manager = Repo.insert! %MissionControlEx.Web.ScheduleManager{
  channel: n1devtest_channel,
  cron: cron,
  status: "waiting",
  is_recurring: false,
}

n2_manager = Repo.insert! %MissionControlEx.Web.ScheduleManager{
  channel: n2devtest_channel,
  cron: cron,
  status: "waiting",
  is_recurring: false,
}

n3_manager = Repo.insert! %MissionControlEx.Web.ScheduleManager{
  channel: n3devtest_channel,
  cron: cron,
  status: "waiting",
  is_recurring: false,
}

# Asset Setup
asset1 = Repo.insert! %MissionControlEx.Web.Asset{
  s3_path: "test/colorful_timer_5min.ts",
  duration: 30_000,
  type: "episode",
  commercial_breaks_ms: [],
  metadata: %{episode: "1", season: "1", title: "This is a title"},
  status: "complete"
}

asset2 = Repo.insert! %MissionControlEx.Web.Asset{
  s3_path: "test/2min.ts",
  duration: 30_000,
  metadata: %{episode: "2", season: "1"},
  commercial_breaks_ms: [],
  status: "complete"
}

asset3 = Repo.insert! %MissionControlEx.Web.Asset{
  s3_path: "test/test_symbols_1min.ts",
  duration: 30_000,
  commercial_breaks_ms: [],
  status: "complete"
}

# n1devtest Schedule Setup
csv_string = """
schedule_block_length,asset_path,commercial_path
0:00:30,test/test_symbols_1min.ts,
0:00:30,test/2min.ts,
"""
{:ok, pid} = StringIO.open(csv_string)
csv = pid |> IO.stream(:line)

%StreamSchedule{
  state: "waiting",
  name: "play_reset_stop_repeat",
  default_schedule: true,
  schedule_manager_id: n1_manager.id,
  repeat: true,
  stop_on_empty: true,
}
|> StreamSchedule.load_event_list_from_csv(csv)
|> Repo.insert!

# n2devtest Schedule Setup
n2_string = """
schedule_block_length,asset_path,commercial_path
0:00:30,test/2min.ts,
0:00:30,test/test_symbols_1min.ts,
"""
{:ok, pid} = StringIO.open(n2_string)
n2_csv = pid |> IO.stream(:line)

%StreamSchedule{
  state: "waiting",
  name: "stopping_n2_schedule",
  default_schedule: true,
  schedule_manager_id: n2_manager.id,
  repeat: false,
  stop_on_empty: true, # stop_on_empty true doesn't mean anything since repeat false
}
|> StreamSchedule.load_event_list_from_csv(n2_csv)
|> Repo.insert!

# n3devtest Schedule Setup
n3_string = """
schedule_block_length,asset_path,commercial_path
0:00:30,test/2min.ts,
0:00:30,test/colorful_timer_5min.ts,
0:00:30,test/test_symbols_1min.ts,
0:01:00,suspend,
"""
{:ok, pid} = StringIO.open(n3_string)
n3_csv = pid |> IO.stream(:line)

%StreamSchedule{
  state: "waiting",
  name: "infinite_n3_schedule",
  default_schedule: true,
  schedule_manager_id: n3_manager.id,
  repeat: true,
  stop_on_empty: false,
}
|> StreamSchedule.load_event_list_from_csv(n3_csv)
|> Repo.insert!
