alias MissionControlEx.Web.{Repo, Channel, StreamSchedule, ScheduleManager}
alias MissionControlEx.Web.Channel
alias MissionControlEx.Web.StreamSchedule

# Things used for everything
{:ok, cron} = Crontab.CronExpression.Parser.parse("* * * * * *", true)
Repo.insert! %MissionControlEx.Web.Asset{
  duration: 1246421,
  commercial_breaks_ms: [371000,642000,1062000,1215000],
  s3_path: "prod/yugioh/YuGiOh_S1E01_episode/final/YuGiOh_S1E01_episode.ts",
  status: "complete"
}
Repo.insert! %MissionControlEx.Web.Asset{
  duration: 1278454,
  commercial_breaks_ms: [279000,758000,1103000,1246000],
  s3_path: "prod/yugioh/YuGiOh_S1E02_episode/final/YuGiOh_S1E02_episode.ts",
  status: "complete"
}
Repo.insert! %MissionControlEx.Web.Asset{
  duration: 1278321,
  commercial_breaks_ms: [427000,646000,1056000,1247000],
  s3_path: "prod/yugioh/YuGiOh_S1E03_episode/final/YuGiOh_S1E03_episode.ts",
  status: "complete"
}
Repo.insert! %MissionControlEx.Web.Asset{
  duration: 1271787,
  commercial_breaks_ms: [342000,607000,1035000,1240000],
  s3_path: "prod/yugioh/YuGiOh_S1E04_episode/final/YuGiOh_S1E04_episode.ts",
  status: "complete"
}
Repo.insert! %MissionControlEx.Web.Asset{
  duration: 485187,
  s3_path: "prod/yugioh/yugioh_brb_8min/final/yugioh_brb_8min.ts",
  status: "complete"
}

# Channels that we can run
channels = [
  %Channel{
    login: "n1devtest",
    oauth_token: "d17i9ifomh5jv7cn6d266te5xjyhrx",
    twitch_profile_id: 158426293
  },
  %Channel{
    login: "n2devtest",
    oauth_token: "qi8oyivzzbpkg7bz2k7r3f0k2jpzev",
    twitch_profile_id: 158617942
  },
  %Channel{
    login: "n3devtest",
    oauth_token: "p0jb1fger9rd1ce3vsmtt01np6dx4w",
    twitch_profile_id: 158618438
  },
  %Channel{
    login: "n4devtest",
    oauth_token: "ml5qdv0s3xxhppw3ol1eospifokcsa",
    twitch_profile_id: 178386821
  },
  %Channel{
    login: "n5devtest",
    oauth_token: "ku0v66txcwa7pkmwd3dbcuxgdqwcs2",
    twitch_profile_id: 178386914
  }
]

channels
|> Enum.map(
  fn(channel) ->
    channel = Repo.insert! channel
    schedule_manager = Repo.insert! %MissionControlEx.Web.ScheduleManager{
      channel: channel,
      cron: cron,
      status: "waiting"
    }
    schedule_manager
  end
)
|> Enum.with_index
|> Enum.map(
  fn
  ({%{channel: channel} = schedule_manager, 0}) ->
    # Clip stream with chat commands
    chat_command = Repo.insert! %MissionControlEx.Web.ChatCommand{
      command: "!current",
      message_template: "<%= data[\"current\"][\"url\"] %>",
      fallback_message: "Can't tell you what's playing, not sure why",
      auto_send: true
    }
    chat_command2 = Repo.insert! %MissionControlEx.Web.ChatCommand{
      command: "!vod",
      message_template: "Check out more by this broadcaster at twitch.tv\/<%= data[\"current\"][\"broadcaster\"][\"display_name\"] %>",
      fallback_message: "Can't tell you what's playing, not sure why",
      auto_send: true
    }
    Repo.insert! %MissionControlEx.Web.ChannelCommand{
      channel: channel,
      chat_command: chat_command
    }
    Repo.insert! %MissionControlEx.Web.ChannelCommand{
      channel: channel,
      chat_command: chat_command2
    }
    %StreamSchedule{
      state: "waiting",
      name: "clips_" <> channel.login,
      default_schedule: true,
      schedule_manager_id: schedule_manager.id,
      api_url: "https://api.twitch.tv/kraken/clips/top?limit=100"
    }
  # ({schedule_manager, 1}) ->
  # ({schedule_manager, 2}) ->
  ({schedule_manager, _}) ->
    # Yugioh stream
    yugi_csv = File.stream!("media/basic_yugi.csv")
    %StreamSchedule{
      state: "waiting",
      name: "yugi_" <> schedule_manager.channel.login,
      default_schedule: true,
      schedule_manager_id: schedule_manager.id,
      repeat: true
    }
    |> StreamSchedule.load_event_list_from_csv(yugi_csv)
  end
)
|> Enum.map(fn(schedule) -> Repo.insert!(schedule) end)