alias MissionControlEx.Web.Repo
alias MissionControlEx.Web.StreamSchedule

{:ok, cron} = Crontab.CronExpression.Parser.parse("* * * * * *", true)

channel = Repo.insert! %MissionControlEx.Web.Channel{
  login: "tpdevtest",
  oauth_token: "rqgyml1g3hgxq4ayfm56a9ghhgowla"
}

schedule_manager = Repo.insert! %MissionControlEx.Web.ScheduleManager{
  channel: channel,
  cron: cron,
  status: "waiting"
}

asset1 = Repo.insert! %MissionControlEx.Web.Asset{
  s3_path: "test/colorful_timer_5min.ts",
  duration: 60_000,
  type: "episode",
  commercial_breaks_ms: [],
  metadata: %{episode: "1", season: "1", title: "This is a title"},
  status: "complete"
}

asset2 = Repo.insert! %MissionControlEx.Web.Asset{
  s3_path: "test/2min.ts",
  duration: 60_000,
  metadata: %{episode: "2", season: "1"},
  commercial_breaks_ms: [],
  status: "complete"
}

short_suspend_csv = File.stream!("media/suspend_test.csv")
%StreamSchedule{
  state: "waiting",
  name: "mst3k",
  default_schedule: true,
  schedule_manager_id: schedule_manager.id,
  repeat: true
}
|> StreamSchedule.load_event_list_from_csv(short_suspend_csv)
|> Repo.insert!
