alias MissionControlEx.Web.{Repo, Asset}
bucket = "twitch-creative-video-repository"

keys_to_delete = ExAws.S3.list_objects(bucket, prefix: "dev/dev_test")
|> ExAws.request!
|> get_in([:body, :contents])
|> Enum.map(&(&1.key))

ExAws.S3.delete_multiple_objects(bucket, keys_to_delete)
|> ExAws.request

asset_three_min = Repo.insert! %MissionControlEx.Web.Asset{
  source_movie: "dev/test_3min.mp4",
  source_subtitles: "dev/test_3min.scc",
  s3_path: "dev/dev_test/test_3min/final/test_3min.ts",
  status: "waiting"
}

asset_34bytes_subs = Repo.insert! %MissionControlEx.Web.Asset{
  source_movie: "dev/test_34bytes_subs.mp4",
  source_subtitles: "dev/test_34bytes_subs.srt",
  s3_path: "dev/dev_test/test_34b/final/test_34b.ts",
  status: "waiting"
}

asset_no_subs_2sec = Repo.insert! %MissionControlEx.Web.Asset{
  source_movie: "dev/test_2sec.mp4",
  source_subtitles: "None_Required",
  s3_path: "dev/dev_test/test_2sec/final/test_2sec.ts",
  status: "waiting"
}

asset_no_subs_2sec_a = Repo.insert! %MissionControlEx.Web.Asset{
  source_movie: "dev/test_2sec.mp4",
  source_subtitles: "None_Required",
  s3_path: "dev/dev_test/test_2sec_trim_a/final/test_2sec_trim_a.ts",
  status: "waiting",
  trimmings: "00:00:00,00:00:01"
}

asset_no_subs_2sec_b = Repo.insert! %MissionControlEx.Web.Asset{
  source_movie: "dev/test_2sec.mp4",
  source_subtitles: "None_Required",
  s3_path: "dev/dev_test/test_2sec_trim_b/final/test_2sec_trim_b.ts",
  status: "waiting",
  trimmings: "00:00:00,00:00:00.5,00:00:01.5,end"
}

asset_with_subs = Repo.insert! %MissionControlEx.Web.Asset{
  source_movie: "dev/test_20sec.mp4",
  source_subtitles: "dev/test_20sec.srt",
  s3_path: "dev/dev_test/with_subs/final/with_subs.ts",
  status: "waiting"
}

asset_trim = Repo.insert! %MissionControlEx.Web.Asset{
  source_movie: "dev/test2.mp4",
  source_subtitles: "dev/test.srt",
  s3_path: "dev/dev_test/with_trim/final/with_trim.ts",
  trimmings: "00:00:00,00:00:10,00:00:50,end",
  status: "waiting",
}

asset_order_subs = Repo.insert! %MissionControlEx.Web.Asset{
  source_movie: "dev/test3.mp4",
  source_subtitles: "order_captions",
  s3_path: "dev/dev_test/order_subs_#{Utils.random_string(4)}/final/order_subs_#{Utils.random_string(4)}.ts",
  status: "waiting"
}

manifest = Repo.insert! %MissionControlEx.Web.Manifest{
  name: "test_manifest",
  assets: [asset_three_min,
    asset_no_subs_2sec,
    asset_no_subs_2sec_a,
    asset_no_subs_2sec_b,
    asset_with_subs,
    asset_trim,
    asset_order_subs,
  ]
}
# asset_five_min = Repo.insert! %MissionControlEx.Web.Asset{
#   source_movie: "dev/test_5min.mp4",
#   source_subtitles: "dev/test_5min.scc",
#   s3_path: "dev/dev_test/test_5min/final/test_5min.ts",
#   status: "waiting"
# }
