alias MissionControlEx.Web.Repo
alias MissionControlEx.Web.StreamSchedule

{:ok, cron} = Crontab.CronExpression.Parser.parse("* * * * * *", true)

channel = Repo.insert! %MissionControlEx.Web.Channel{
  login: "tpdevtest",
  oauth_token: "rqgyml1g3hgxq4ayfm56a9ghhgowla"
}

schedule_manager = Repo.insert! %MissionControlEx.Web.ScheduleManager{
  channel: channel,
  cron: cron,
  status: "waiting"
}

Repo.insert! %MissionControlEx.Web.Asset{
  duration: 1246421,
  commercial_breaks_ms: [371000,642000,1062000,1215000],
  s3_path: "prod/yugioh/YuGiOh_S1E01_episode/final/YuGiOh_S1E01_episode.ts",
  status: "complete"
}
Repo.insert! %MissionControlEx.Web.Asset{
  duration: 1278454,
  commercial_breaks_ms: [279000,758000,1103000,1246000],
  s3_path: "prod/yugioh/YuGiOh_S1E02_episode/final/YuGiOh_S1E02_episode.ts",
  status: "complete"
}
Repo.insert! %MissionControlEx.Web.Asset{
  duration: 1278321,
  commercial_breaks_ms: [427000,646000,1056000,1247000],
  s3_path: "prod/yugioh/YuGiOh_S1E03_episode/final/YuGiOh_S1E03_episode.ts",
  status: "complete"
}
Repo.insert! %MissionControlEx.Web.Asset{
  duration: 1271787,
  commercial_breaks_ms: [342000,607000,1035000,1240000],
  s3_path: "prod/yugioh/YuGiOh_S1E04_episode/final/YuGiOh_S1E04_episode.ts",
  status: "complete"
}
Repo.insert! %MissionControlEx.Web.Asset{
  duration: 485187,
  s3_path: "prod/yugioh/yugioh_brb_8min/final/yugioh_brb_8min.ts",
  status: "complete"
}

yugi_csv = File.stream!("media/basic_yugi.csv")
%StreamSchedule{
  state: "waiting",
  name: "mst3k",
  default_schedule: true,
  schedule_manager_id: schedule_manager.id,
  repeat: true
}
|> StreamSchedule.load_event_list_from_csv(yugi_csv)
|> Repo.insert!
