

module "bs-staging" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-creative-dev"
  eb_application_name = "${module.bs-app-staging.beanstalk_application_name}"
  vpc_id = "vpc-52fe4a36"
  ec2_subnet_ids = "subnet-e9d0608d,subnet-1f438969,subnet-47aeb41e"
  elb_subnet_ids = "subnet-e9d0608d,subnet-1f438969,subnet-47aeb41e"
  elb_loadbalancer_security_groups = "sg-6967730e"
  auto_scaling_lc_security_groups = "sg-6967730e"
  solution_stack_name = "64bit Amazon Linux 2016.09 v2.5.0 running Multi-container Docker 1.12.6 (Generic)"
  auto_scaling_lc_instance_type = "c4.large"
  owner = "jwahba@twitch.tv"
  service = "creative/mission-control-ex"
  env = "staging"
  associate_public_address = "true"

}
