defmodule EventFetchPersistApiTest do
  use ExUnit.Case, async: true
  # use Plug.Test
  use MissionControlEx.Web.ConnCase
  use MissionControlEx.Web.ModelCase

  import MissionControlEx.Web.Factory
  import MissionControlEx.Test.TestHelpers
  alias MissionControlEx.Web.{Router, Repo, Event, StreamSchedule, ScheduleManager, EventChunk}

  @test_csv File.stream!("test/schema/test_schedule.csv")
  @suspend_csv File.stream!("test/schema/test_suspend_schedule.csv")

  test "get and persist until end with interruption", %{conn: conn} do
    insert_assets_with_commercial_breaks(8)
    # See test_helper.exs for more context on the schedule manager and schedule
    # created here
    schedule_manager = make_schedule_manager(@test_csv)

    events =
      ScheduleManager.generate_http_chunk_stream(schedule_manager)
      |> EventChunk.chunk_stream_to_event_stream()
      |> Enum.take(35)
      |> Enum.map(fn event -> Event.process_persist_update(event) end)

    assert length(events) == 35

    [stream_schedule | _] = schedule_manager.stream_schedules

    stream_schedule
    |> StreamSchedule.load()
    |> Map.get(:queued_event_chunks)

    end_events =
      ScheduleManager.load(schedule_manager.id)
      |> ScheduleManager.generate_http_chunk_stream()
      |> EventChunk.chunk_stream_to_event_stream()
      |> Enum.take(10)

    # Behavior changed, API will spit out "end_stream" on every request after one-run stream ends
    Enum.each(end_events, fn event -> assert event.type == "end_stream" end)
    assert length(end_events) == 10
  end

  test "doesn't fast forward too far", %{conn: conn} do
    insert_assets_with_commercial_breaks(8)
    # See test_helper.exs for more context on the schedule manager and schedule
    # created here
    schedule_manager = make_schedule_manager(@test_csv)

    events =
      ScheduleManager.generate_http_chunk_stream(schedule_manager)
      |> EventChunk.chunk_stream_to_event_stream()
      |> Enum.take(3)
      |> Enum.map(fn event -> Event.process_persist_update(event) end)

    assert length(events) == 3

    [stream_schedule | _] = schedule_manager.stream_schedules

    played_length =
      stream_schedule
      |> StreamSchedule.load()
      |> Map.get(:played_event_chunks)
      |> length

    assert played_length == 1
  end
end
