defmodule MissionControlEx.Web.Factory do
  use ExMachina.Ecto, repo: MissionControlEx.Web.Repo

  def channel_factory do
    %MissionControlEx.Web.Channel{
      login: "tdevtest",
      oauth_token: "token"
    }
  end

  def asset_factory do
    %MissionControlEx.Web.Asset{
      s3_path: sequence(:s3_path, &"s3_path-#{&1}.mp4"),
      status: "complete"
    }
  end

  def stream_schedule_factory do
    %MissionControlEx.Web.StreamSchedule{}
  end

  def schedule_manager_factory do
    %MissionControlEx.Web.ScheduleManager{}
  end

  def chat_command_factory do
    %MissionControlEx.Web.ChatCommand{}
  end

  def channel_command_factory do
    %MissionControlEx.Web.ChannelCommand{}
  end

  def manifest_factory do
    %MissionControlEx.Web.Manifest{
      name: "test_manifest",
      status: "waiting",
      manifest: ""
    }
  end
end
