ActiveAdmin.register_page "Add Video To Stream Session" do
  content do
    if params[:id]
      render partial: 'add_video_to_stream_session', locals: {stream_session: StreamSession.find(params[:id]) }
    end
  end

  page_action :add_video, method: :post do
    stream_session = StreamSession.find(params[:id])
    video = Video.find(params[:video_id])
    if params[:append]
      stream_session.append_video(video)
    elsif params[:prepend]
      stream_session.prepend_video(video)
    elsif params[:interleave]
      stream_session.interleave_video(video)
    end
    redirect_to :back, notice: "Video Added #{params[:video_id]}"
  end

  page_action :stream_session_video, method: :delete do
    StreamSessionVideo.find(params[:id]).remove
    redirect_to :back, notice: "Video Added #{params[:video_id]}"
  end


end
