ActiveAdmin.register Channel do
  permit_params :name, :stream_key
  show do
    attributes_table do
      row :name
      row :stream_key
      row :created_at
      row :updated_at
    end
    panel "Videos" do
      videos = channel.videos
      table_for videos do
        column :show
        column :s3_path
        column :channel_id
        column :length
      end
    end
    panel "Stream Sessions" do
      stream_sessions = channel.stream_sessions
      table_for stream_sessions do
        column :id do |ss|
          a(ss.id, href: admin_stream_session_path(ss))
        end
        column :start_time
        column :state
      end
    end
  end
end
