ActiveAdmin.register StreamSession do
  permit_params :channel_id, :state, :indefinite, :start_time_date, :start_time_time_hour, :start_time_time_minute
  show do
    attributes_table do
      row :channel_id
      row :start_time
      row :state
      row :indefinite
      row :updated_at
      row :created_at
    end
    panel "Videos" do
      videos = stream_session.videos
      table_for videos do
        column :title
        column :s3_path
        column :channel_id
        column :length
      end
    end
  end

  form do |f|
    h3 "The current time is #{Time.now}"
    f.inputs do
      f.input :channel
      f.input :start_time, :as => :just_datetime_picker, :input_html => { :value => Time.now }
      f.input :state
      f.input :indefinite
    end
    f.submit
  end


  action_item :edit, only: :show do
    link_to 'Add Video to Stream Session', admin_add_video_to_stream_session_path(id: stream_session.id)
  end

  action_item :edit, only: :show do
    button_to 'Deep Copy', deep_duplicate_admin_stream_session_path(id: stream_session.id)
  end

  member_action :deep_duplicate, method: :post do
    ss = resource.deep_duplicate
    redirect_to resource_path(ss.id), notice: "Deep Duplicated!"
  end
end
