class ApiError
  def initialize(message, code)
    @message = message
    @code = code
  end

  def payload
    {
      json: {
        message: @message,
        status:  @code.to_s,
        error:   Rack::Utils::HTTP_STATUS_CODES[@code]
      },
      status: @code
    }
  end
end
