class Channel::StreamSessionsController < ApplicationController
  skip_before_action :verify_authenticity_token
  before_action :set_channel
  before_action :set_stream_session, only: [:show, :destroy, :update]

  def show
    render json: @stream_session.as_json(stream_session_attributes)
  end

  def destroy
    @stream_session.cancel
    @stream_session.save!
    render json: @stream_session.as_json(stream_session_attributes)
  end

  def create
    @stream_session = @channel.stream_sessions.build(stream_session_params)
    if @stream_session.save
      render json: @stream_session.as_json(stream_session_attributes)
    else
      render ApiError.new(@stream_session.errors.full_messages.join("\n"), 422).payload
    end
  end

  def update
    if @stream_session.update_attributes(stream_session_params)
      render json: @stream_session.as_json(stream_session_attributes)
    else
      render ApiError.new(@stream_session.errors.full_messages.join("\n"), 422).payload
    end
  end

  def stream_session_params
    params.permit(:start_time, :indefinite)
  end

  def set_channel
    @channel = Channel.find_by(name: params[:channel_name])
    if @channel.nil?
      render ApiError.new("Channel Not Found", 404).payload
    end
  end

  def set_stream_session
    if params[:id] == "current"
      @stream_session = @channel.current_stream_session
    else
      @stream_session = StreamSession.find_by(id: params[:id])
    end

    if @stream_session.nil?
      render ApiError.new("Stream Session Not Found", 404).payload
    end
  end

  def stream_session_attributes
    {
      include: {
        current_stream_session_video: ssv_attributes,
        next_stream_session_video: ssv_attributes,
        stream_session_videos: ssv_attributes,
        channel: {}
      }
    }
  end

  def ssv_attributes
    {
      include: [:video],
      methods: [:time_left]
    }
  end
end
