class Channel::VideosController < ApplicationController
  skip_before_action :verify_authenticity_token
  before_action :set_channel

  def index
    if params[:random] == "true"
      if params[:excluded_videos_ids]
        exclusions = Video.where(id: params[:excluded_videos_ids].split(","))
      else
        exclusions = []
      end
      @videos = Video.get_random(@channel, number: params[:limit].to_i, exclusions: exclusions)
    else
      @videos = @channel.videos
      count = @videos.count
      if params[:limit]
        @videos = @videos.limit(params[:limit].to_i)
      end
      if params[:offset]
        @videos = @videos.offset(params[:offset].to_i)
      end
    end
    render json: {videos: @videos.as_json(root: false), _total: count}
  end

  def show
    render json: Video.find_by(id: params[:id])
  end

  def set_channel
    @channel = Channel.find_by(name: params[:channel_name])
    if @channel.nil?
      render ApiError.new("Channel Not Found", 404).payload
    end
  end
end
