class StreamSessionVideosController < ApplicationController
  skip_before_action :verify_authenticity_token
  def show
    render json: StreamSessionVideo.find(params[:id]).as_json(include: {video: {methods: [:s3_url] }})
  end

  def update
    stream_session_video = StreamSessionVideo.find(params[:id])
    stream_session_video.update_attributes(stream_session_video_params)
    if stream_session_video.seconds_streamed > 0 and stream_session_video.state == "unstreamed"
      stream_session_video.update_attributes(state: "streaming")
      stream_session_video.channel.update_status(stream_session_video.video)
    end
    stream_session_video.stream_session.touch

    render json: stream_session_video.as_json(include: :video)
  end

  def stream_session_video_params
    params.require(:stream_session_video).permit(:seconds_streamed, :state)
  end
end
