class StreamSessionsController < ApplicationController
  skip_before_action :verify_authenticity_token
  def pop
    ss = StreamSession.pop
    if ss.present?
      render json: StreamSession.find(ss.id).as_json(stream_session_attributes)
    else
      render json: nil, status: 204
    end
  end

  def show
    render json: StreamSession.find(params[:id]).as_json(stream_session_attributes)
  end

  def update
    stream_session = StreamSession.find(params[:id])
    ssvs = stream_session.stream_session_videos

    new_state = params[:stream_session][:state]
    if new_state  == "finished"
      stream_session.finish
    end

    if new_state  == "canceled"
      stream_session.cancel
    end
    stream_session.save!
    render json: stream_session.as_json(stream_session_attributes)
  end

  def file_list
    @stream_session = StreamSession.find_by(id: params[:stream_session_id])
    order = params[:order].to_i
    if @stream_session
      @stream_session.ensure_indefinite_stream_session
      if order > 1
        prior_stream_session_video = @stream_session.stream_session_videos.where("\"order\" < ? ", order)
        prior_stream_session_video.update_all(state: "finished")
      end
      @stream_session_video = @stream_session.stream_session_videos.where("\"order\" >= ?", order).where(state: ["unstreamed", "streaming"]).order(:order).first
    end
    render 'file_list.txt.erb'
  end

  def stream_session_params
    params.require(:stream_session).permit(:state)
  end

  def stream_session_attributes
    {
      include: {
        channel: {}
      }
    }
  end
end
