class VideosController < ApplicationController
  skip_before_action :verify_authenticity_token
  def show
    render json: Video.find(params[:id]).as_json()
  end

  def index
    render json: Video.all.as_json(root:false)
  end

  def update
    video = Video.find(params[:id])
    video.update_attributes(video_params)
    render json: video.as_json(root: false)
  end

  def create
    @video = Video.new(video_params)
    if @video.save
      render json: @video.as_json(video_attributes)
    else
      render ApiError.new(@video.errors.full_messages.join("\n"), 422).payload
    end
  end

  def video_params
    params.require(:video).permit(:title, :show, :season, :s3_path, :channel_id, :length, :created_at, :updated_at, :deleted_at, :unlocked_by, :unlocked)
  end
end
