class StreamSessionVideo < ApplicationRecord
  belongs_to :stream_session
  belongs_to :video
  has_one :channel, through: :stream_session

  def remove
    stream_session.stream_session_videos
      .select { |ssv| ssv.order > order }
      .each {|ssv| ssv.update_attributes(order: ssv.order - 1)}
    destroy!
  end

  def unstreamed
    state == 'unstreamed'
  end

  def finished?
    state == 'finished'
  end

  def time_left
    [video.length - seconds_streamed, 0].max
  end
end
