class Video < ApplicationRecord
  belongs_to :channel
  has_many :stream_session_videos

  def self.get_random(channel, number: 1, exclusions:)
    possible_videos = channel.videos - exclusions
    if possible_videos.empty?
      return channel.videos.sample(number)
    end
    possible_videos.sample(number)
  end

  def self.sync_with_s3(prefix: '')
    S3.list_objects(bucket: 'twitch-creative-video-repository', prefix: prefix).to_a.shuffle
      .each do |page|
        page.contents.shuffle.each do |file|
          file_parts = file.key.split("/")
          if file.key.end_with?(".mp4") && file_parts.length == 4 && file_parts[0] != "video_processing"
            channel_name, show, season, title = file_parts
            channel = Channel.find_by(name: channel_name)
            if channel.present?
              video = Video.find_or_create_by(
                channel_id: channel.id,
                show: show,
                title: title,
                season: season,
                s3_path: file.key
              )
              if video.length == 0 || video.length.nil?
                video.length = video.compute_length
              end
              video.save!
            end
          end
        end
      end
  end

  def compute_length
    `ffprobe  -protocol_whitelist file,http,https,tcp,tls -i "#{s3_url}" -show_format | grep duration | sed 's/duration=//'`.to_i
  end

  def s3_url
    S3_SIGNER.presigned_url(
      :get_object,
      bucket: 'twitch-creative-video-repository',
      key: s3_path,
      expires_in: 1.week
    )
  end

  def signed_s3_path
    s3_url.gsub("https://twitch-creative-video-repository.s3-us-west-2.amazonaws.com/", "")
  end
end
