Rails.application.routes.draw do
  get "/health", to: 'health#show'
  ActiveAdmin.routes(self)

  # SYNDICATOR API
  resources :videos


  # STREAMER API
  namespace :stream_sessions do
    post :pop
  end
  resources :stream_sessions do
    get "file_list/:order", to: 'stream_sessions#file_list', as:  'file_list'
  end
  resources :stream_session_videos

  #CHAT BOT API
  scope "channels/:channel_name", as: "channels", module: "channel" do
    resources :stream_sessions, only: [:destroy, :show, :create, :update] do
      resources :videos, only: [:create],  module: "stream_sessions"
    end
    resources :videos, only: [:index, :show]
  end
end
