import React, { Component } from 'react';
import { Line } from 'rc-progress';
import { Link } from 'react-router';
import styles from './Step1.css';
import MacInstaller from '../installers/macInstaller';
import WinInstaller from '../installers/winInstaller';

const INSTALLERS = {
  darwin: new MacInstaller(),
  win32: new WinInstaller()
};

export default class Step1 extends Component {
  constructor(props) {
    super(props);
    this.state = {
      progress: 0,
      logs: []
    };
  }

  setProgress(percentage) {
    this.setState({ progress: percentage });
  }

  logger(message) {
    this.setState({ logs: this.state.logs.concat([message]) });
  }

  install() {
    INSTALLERS[process.platform].install(this.setProgress.bind(this), this.logger.bind(this));
  }

  nextAction() {
    if (this.state.progress !== 100) {
      return (
        <Link onClick={this.install.bind(this)}>
          <i className="fa fa-download  fa-3x" />
        </Link>
      );
    }
    return (
      <Link to="/step_2">
        <i className="fa fa-arrow-right fa-3x" />
      </Link>
    );
  }

  renderLog(logs) {
    return logs.map((message) => <div key={message}>{message}</div>);
  }

  render() {
    return (
      <div>
        <Link to="/">
          <i className="fa fa-arrow-left fa-3x" />
        </Link>
        <div className={styles.container}>
          <h2>{'Install OBS and Audio Driver'}</h2>
          <Line percent={this.state.progress} strokeWidth="4" strokeColor="#D3D3D3" />
          {this.nextAction()}
          <div>
            {this.renderLog(this.state.logs)}
          </div>
        </div>
      </div>
    );
  }
}
