import https from 'https';
import fs from 'fs';
import tmp from 'tmp-promise';

const tmpDir = tmp.dirSync();

export default class Installer {
  downloadFile(filename) {
    return new Promise((resolve, reject) => {
      const lastPart = filename.substr(filename.lastIndexOf('/') + 1);
      const filePath = `${tmpDir.name}/${lastPart}`;
      console.log(filePath);
      const file = fs.createWriteStream(filePath);
      return https.get(filename, (response) => {
        response.pipe(file);
        response.on('end', () => { resolve(filePath); });
        response.on('error', (error) => { reject(error); });
      });
    });
  }
}
