import { exec } from 'child-process-promise';
import Installer from './installer';
import { fileRead } from '../utils/obs';

export default class WinInstaller extends Installer {
  install(setProgress, logger) {
    Promise.resolve()
    .then(() => logger('Downloading obs'))
    .then((this.ensureObsDownloaded.bind(this)))
    .then((obsPath) => {
      logger('Installing OBS');
      return obsPath;
    })
    .then(this.ensureOBSInstalled.bind(this))
    .then(() => logger('OBS Installed'))
    .then(() => logger('Opening and Closing OBS to make sure everything is setup correctly'))
    .then(this.ensureOBSLicenseAccepted.bind(this))
    .then(() => setProgress(100))
    .catch((err) => console.log(err));
  }

  ensureObsDownloaded() {
    return this.downloadFile('https://s3-us-west-2.amazonaws.com/twitch-creative-assets/streamer_setup/obs_installer.exe');
  }

  obsInstalled() {
    return Promise.resolve()
    .then(() => exec('dir "%appdata%\\obs-studio"'))
    .then(() => true)
    .catch(() => false);
  }

  ensureOBSInstalled(obsPath) {
    return Promise.resolve()
    .then(this.obsInstalled)
    .then((obsInstalled) => {
      if (obsInstalled) return Promise.resolve();
      return Promise.resolve()
        .then(() => exec(`${obsPath}`.replace(/\\/g, '\\/')))
    })
    .catch(this.ensureOBSInstalled.bind(this));
  }

  obsLicenseAccepted() {
    return Promise.resolve()
    .then(() => fileRead('global.ini', 'ini').LicenseAccepted || fileRead('global.ini', 'ini').General.LicenseAccepted)
    .catch(() => false)
  }

  ensureOBSLicenseAccepted() {
    return Promise.resolve()
    .then(this.obsLicenseAccepted)
    .then((obsLicenseAccepted) => {
      if (obsLicenseAccepted) return Promise.resolve();
      return Promise.resolve()
      .then(() => exec('cd "%ProgramFiles(x86)%\\obs-studio\\bin\\64bit" && "%ProgramFiles(x86)%\\obs-studio\\bin\\64bit\\obs64.exe"'))
      .then(this.obsLicenseAccepted)
      .then((confirmObsLicenseAccepted) => {
        if (!confirmObsLicenseAccepted) {
          return this.ensureOBSLicenseAccepted();
        }
        return Promise.resolve();
      });
    })
    .catch(this.ensureOBSLicenseAccepted.bind(this));
  }
}
