import fs from 'fs';
import ini from 'ini';
import _ from 'lodash';

const OBS_SUPPORT_DIRECTORY = {
  darwin: `${getUserHome()}/Library/Application Support/obs-studio/`,
  win32: `${getUserHome()}/AppData/Roaming/obs-studio/`
}[process.platform];

export function fileUpdate(path, changes, ext) {
  const serializedPayload = fs.readFileSync(`${OBS_SUPPORT_DIRECTORY}${path}`, "utf8");
  const payload = deserialize(ext, serializedPayload);
  const newPayload = _.merge(payload, changes);
  const serializedNewPayload = serialize(ext, newPayload);
  fs.writeFileSync(`${OBS_SUPPORT_DIRECTORY}${path}`, serializedNewPayload);
}

export function fileRead(path, ext) {
  const serializedPayload = fs.readFileSync(`${OBS_SUPPORT_DIRECTORY}${path}`, "utf8");
  return deserialize(ext, serializedPayload);
}

export function fileCreate(path, payload, ext) {
  const serializedNewPayload = serialize(ext, payload);
  fs.writeFileSync(`${OBS_SUPPORT_DIRECTORY}${path}`, serializedNewPayload);
}

function getUserHome() {
  return process.env.HOME || process.env.USERPROFILE;
}

function deserialize(ext, payload) {
  switch (ext) {
    case 'ini': {
      return ini.parse(payload);
    }
    case 'json': {
      return JSON.parse(payload);
    }
    default: {
      throw new Error(`Extension ${ext} invalid`);
    }
  }
}

function serialize(ext, payload) {
  switch (ext) {
    case 'ini': {
      return ini.stringify(payload);
    }
    case 'json': {
      return JSON.stringify(payload);
    }
    default: {
      throw new Error(`Extension ${ext} invalid`);
    }
  }
}
