#!/bin/bash
set -e -x

IMAGE=docker-registry.internal.justin.tv/creativeapi:$GIT_COMMIT

docker build -t $IMAGE .
docker push $IMAGE

cat <<EOF > Dockerrun.aws.json
{
    "AWSEBDockerrunVersion": 2,
    "volumes": [{
      "name": "nginx-proxy-conf",
      "host": {
        "sourcePath": "/var/app/current/proxy/conf.d"
      }
    }],
    "containerDefinitions": [
        {
        "name": "api",
    		"image": "$IMAGE",
        "memory": 256,
    		"essential": true
        },
        {
         "name": "nginx-proxy",
         "image": "nginx",
         "essential": true,
         "memory": 128,
         "portMappings": [
           {
             "hostPort": 80,
             "containerPort": 80
           }
         ],
         "links": [
           "api"
         ],
         "mountPoints": [
           {
             "sourceVolume": "awseb-logs-nginx-proxy",
             "containerPath": "/var/log/nginx"
           },
           {
             "sourceVolume": "nginx-proxy-conf",
             "containerPath": "/etc/nginx/conf.d",
             "readOnly": true
           }
         ]
       }
    ]
}
EOF

zip api.zip Dockerrun.aws.json
