defmodule Outreachtool.SearchScraper do
  alias Experimental.Flow

  @upload_date_to_param %{
    "ever" => "",
    "hour" => "EgIIAQ%253D%253D",
    "day" => "EgIIAg%253D%253D",
    "week" => "EgIIAw%253D%253D",
    "month" => "EgIIBA%253D%253D",
    "year" => "EgIIBQ%253D%253D",
  }


  def get_users(query, date_range, page_offset \\ 1, num_of_pages \\ 2) do
    scrape(query, date_range, page_offset, num_of_pages)
    |> Enum.map(fn(%{"uploader_url" => uploader_url, "uploader" => uploader}) -> {uploader_url, uploader} end)
  end

  def scrape(query, date_range, page_offset \\ 1, num_of_pages \\ 2) do
    page_offset..(page_offset + num_of_pages)
    |> Flow.from_enumerable(stages: 20)
    |> Flow.partition(min_demand: 0, max_demand: 1, stages: 20)
    |> Flow.map(&(System.cmd("youtube-dl",
      ["https://www.youtube.com/results\?search_query=#{URI.encode(query)}\&sp=#{upload_param(date_range)}\&page\=#{&1}", "-J", "--skip-download"])))
    |> Enum.to_list
    |> Enum.map(fn({payload, _}) -> Poison.decode(payload) end)
    |> Enum.filter(fn({status, _}) -> status == :ok end)
    |> Enum.map(fn({_, payload}) -> payload end)
    |> Enum.flat_map(fn(result) -> Map.get(result, "entries") end)
  end


  def upload_param(date_range) do
    Map.get(@upload_date_to_param, date_range)
  end

  def generate_report(query, date_range, page_offset \\ 1, num_of_pages \\ 2) do
    scrape(query, date_range, page_offset, num_of_pages)
    |> Enum.group_by(fn(video) -> Map.get(video, "uploader_url") end)
    |> Enum.map(fn({user, videos}) -> [user, Enum.count(videos), Enum.reduce(videos, 0, fn(video, accum) ->  (Map.get(video, "view_count") + accum) / Enum.count(videos)  end)] end)
  end

  def add_profiles(rows) do
    rows
    |> Flow.from_enumerable
    |> Flow.partition(stages: 20)
    |> Flow.map(&add_profile/1)
    |> Enum.to_list
  end

  def add_profile([youtube_url|_] = row) do
    user = User.populate(%User{youtube_url: youtube_url})
    row ++ [
      user.youtube_url,
      user.youtube_subscribers,
      user.instagram_url,
      user.instagram_followers,
      user.twitter_url,
      user.twitter_followers,
      user.patreon_url,
      user.patreon_patrons,
      user.instagram_url,
      user.instagram_followers,
      user.twitch_url,
      user.twitch_followers,
    ]
  end

  def to_csv(list, headers) do
    report = list
    |> CSV.encode
    |> Enum.to_list
    |> to_string
    Enum.join(headers, ",") <>"\n" <> report
  end
end
