defmodule SQS do
  def send_in_batches(messages) do
    messages
    |> Enum.chunk(10, 10, [])
    |> Enum.map(&send_batch_to_sqs/1)
    |> Task.yield_many()
  end

  def send_batch_to_sqs(messages) do
    Task.Supervisor.async_nolink(Outreachtool.TaskSupervisor, fn() ->
      messages = messages|> wrap_in_sqs_batch
      ExAws.SQS.send_message_batch("instagram-user-scrape", messages) |> ExAws.request
    end)
  end

  def wrap_in_sqs_batch(messages) do
    messages
    |> Enum.with_index
    |> Enum.map(fn({message, id}) ->
      [
        id: id,
        message_body: message
      ]
    end)
  end
end
