defmodule Outreachtool.PageController do
  use Outreachtool.Web, :controller
  @youtube_headers ["url","video_count","average_views","youtube_url","youtube_subscribers","instagram_url","instagram_followers","twitter_url","twitter_followers","patreon_url","patreon_patrons","instagram_url","instagram_followers","twitch_url","twitch_followers","email"]
  @headers [:youtube_url, :youtube_subscribers, :instagram_url, :instagram_followers, :twitter_url, :twitter_followers, :patreon_url, :patreon_patrons, :instagram_url, :instagram_followers, :twitch_url, :twitch_followers, :email]
  require IEx
  def search(conn, %{"q" => q, "num_of_pages" => num_of_pages, "date_range" => date_range, "page_offset" => page_offset}) do
    {num_of_pages, _} = Integer.parse(num_of_pages)
    {page_offset, _} = Integer.parse(page_offset)
    {{year, month, day}, _}  = :os.timestamp |> :calendar.now_to_datetime
    list_of_items = Outreachtool.SearchScraper.generate_report(q, date_range, page_offset, num_of_pages)
    |> Outreachtool.SearchScraper.add_profiles
    conn
    |> put_resp_content_type("text/csv")
    |> put_resp_header("content-disposition", "attachment; filename=\"#{q}_#{date_range}_#{page_offset}_#{num_of_pages}__#{year}-#{month}-#{day}_report.csv\"")
    |> send_resp(200, Outreachtool.SearchScraper.to_csv(list_of_items, @youtube_headers))
  end
  def index(conn, _params) do
    render conn, "index.html"
  end

  def profile(conn, %{"youtube_url" => youtube_url}) do
    root = case youtube_url do
      "http://youtube.com" <> root -> root
      "https://youtube.com" <> root -> root
      "youtube.com" <> root -> root
      "www.youtube.com" <> root -> root
      "https://www.youtube.com" <> root -> root
      "http://www.youtube.com" <> root -> root
    end
    profile = User.populate(%User{youtube_url: "https://www.youtube.com/"<>root})
    conn
    |>  assign(:profile, profile)
    |> render "profile.html"
  end

  def search(conn, %{"twitch_users" => twitch_users}) do
    {{year, month, day}, _}  = :os.timestamp |> :calendar.now_to_datetime

    report = twitch_users
    |> String.split("\r\n")
    |> Enum.map(&(%User{twitch_url: "https://www.twitch.tv/#{&1}"}))
    |> Enum.map(&User.populate/1)
    |> to_csv(@headers)

    conn
    |> put_resp_content_type("text/csv")
    |> put_resp_header("content-disposition", "attachment; filename=\"#{year}-#{month}-#{day}_report.csv\"")
    |> send_resp(200, report)
  end

  def to_csv(objs, headers) do
    report = objs
    |> Enum.map(fn(obj) ->
      Enum.map(headers, fn(header) -> Map.get(obj, header) end)
    end)
    |> CSV.encode
    |> Enum.to_list
    |> to_string
    Enum.join(headers, ",") <>"\n" <> report
  end
end
